Attribute VB_Name = "Module1"
Option Explicit

Public IniPathParGen As String
Public IniPath As String


'Type per settare i parametri pubblici dell'applicazione
   Private Type gtAppParam
      gReadOnly As Boolean
      gErrList() As String
   End Type
   Public AppParam As gtAppParam

'Type per la gestione degli Errori
   Private Type ErrorLoad
      eErrEnabled As Boolean
      eErrText As String
      eErrRoutine As String
   End Type
   Public tErrorLoad As ErrorLoad

'Type contenente i dati della Licenza del Cliente
   Private Type mtLicenza
      lScadenza As String
      lScadeGG As Integer
      lGGExtraScadenza As Integer
   End Type
   Public tLicenza As mtLicenza



'Public ConnessioneGenerale As ADODB.Connection  'punta all'mdb GENERALE che si trova sotto la directory "[App.path]&\DB\Generale.mdb"

'Private Declare Function ReleaseCapture Lib "user32" () As Long 'per risolvere il problema dell'errore di RUN-TIME 400 (chiamata form modali)

'Constanti per spostare la Splash form che non ha la barra di windows nella finestra
Public Declare Function ReleaseCapture Lib "user32" () As Long
Public Const WM_NCLBUTTONDOWN = &HA1
Public Const HTCAPTION = 2
Public Const EM_GETLINECOUNT = &HBA

Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, _
ByVal wMsg As Long, ByVal WParam As Long, lParam As Any) As Long

'Costante x la conversione del Path DOS
Public Const SW_SHOWNORMAL As Long = 1

'Per aprire i file in automatico
Declare Function ShellExecute Lib "shell32.dll" _
Alias "ShellExecuteA" _
(ByVal hWnd As Long, ByVal lpOperation As String, _
ByVal lpFile As String, ByVal lpParameters As String, _
ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long


'Per leggere nel file INI
Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpDefault As String, _
                   ByVal lpReturnedString As String, _
                   ByVal nSize As Long, _
                   ByVal lpFileName As String) _
                  As Long

Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" _
                  (ByVal lpApplicationName As String, _
                   ByVal lpKeyName As Any, _
                   ByVal lpString As Any, _
                   ByVal lpFileName As String) _
                  As Long


Public Site As String

Public Const CB_GETDROPPEDSTATE As Long = &H157
Public Const CB_SHOWDROPDOWN As Long = &H14F

Declare Function SendMessageAsLong _
Lib "user32" _
Alias "SendMessageA" ( _
ByVal hWnd As Long, _
ByVal wMsg As Long, _
ByVal WParam As Long, _
ByVal lParam As Long) As Long

'****  DICHIARAZIONI PER I Form SEMPRE IN PRIMO PIANO   ****
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, _
                                                    ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, _
                                                    ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_SHOWWINDOW = &H40
Const HWND_NOTOPMOST = -2
Const HWND_TOPMOST = -1


Sub Main()

   'If App.PrevInstance Then End
   
   'Setto le variabili CSS
      Call SetCSSApp
      
   'Path dei file cnf
      IniPath = App.Path + "\ParRID.CNF"
   
   
   'Se true significa che si deve aprire SEMPRE (serve soprattuto in sviluppo)
      AppParam.gReadOnly = (ReadINI("PARAMETRI", "READ_ONLY", IniPath) = "T")
   
   
   Call MsgInLogFile(String(60, "~"), "")
               
               
   'Questo PARAMETRO comanda su tutte le altre configurazioni
      'If Len(Trim(IniPathParGen)) = 0 Then
         'Controllo se c' un ParGen.CNF nel App.Path e nel qual caso comanda
         If VerificaEsistenzaFile(App.Path & "\ParGen.cnf") Then
            IniPathParGen = App.Path & "\ParGen.cnf"
         Else
            IniPathParGen = App.Path & "\..\..\ParGen.cnf"
         End If
      'End If

   'Se arriva qui controllo che il ParGen esista. In caso contrario ESCO
      If VerificaEsistenzaFile(IniPathParGen) = False Then
         Call MsgInLogFile("Sub 'MAIN' - File di configurazione non trovato! (" & IniPathParGen & ")", "SubMAIN", True, True)
      End If
      
            
   'Cancello eventuali file di log dell'anno precedente in modo da non creare file spazzatura
      Call KillaFile(App.Path & "\Log\LogUpdater_" & (Year(Date) - 1) & "." & Format(Date, "mm") & ".cnf")
   
   'Apro la FormMAIN
      'Call SetAlwaysOnTopMode(FormMAIN)
      FormMAIN.Show

End Sub

'Public Sub ApriConnessione()
'   'Qui mi collego al Database
'   Set ConnessioneGenerale = New ADODB.Connection
'
'   ConnessioneGenerale.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source =" & App.Path & "\Abilitazioni.mdb;Jet OLEDB:Database Password='';"
'   ConnessioneGenerale.Open
'   ConnessioneGenerale.CursorLocation = adUseClient
'End Sub
'Public Sub ChiudiConnessione()
'   On Error Resume Next
'   ConnessioneGenerale.Close
'End Sub

Public Function NonNullo(Argomento As Variant, Optional Numerico As Boolean) As Variant
   If IsNull(Argomento) Then
      If Numerico = False Then
         NonNullo = ""
      Else
         NonNullo = "0"
      End If
   Else
      If Numerico = False Then
         NonNullo = Argomento
      Else
         If IsNumeric(Argomento) = True Then 'Qui faccio un ulteriore controllo se il valore deve essere numerico
            NonNullo = Argomento
         Else
            NonNullo = "0"
         End If
      End If
   End If
End Function


Public Function DataOraSQL(ByVal strData As String, Optional StrOra As Boolean, _
                           Optional OraDB As String, Optional DataConOra As Boolean) As String

   Dim DataEora As String
   Dim vOra As String
   Dim vDat As String

'ACCESS
'   If gTipoDB = 0 Then
      If StrOra Then
         'DataEora = (Mid(StrData, 4, 2) & "/" & Left(StrData, 2) & "/" & Right(StrData, 2)) & " " & Str(Hour(Time)) & ":" & Trim(Str(Minute(Time))) & ":" & Trim(Str(Second(Time)))
         DataEora = Format(strData, "hh:mm")
         DataEora = Replace(strData, ".", ":")
      Else
         vDat = Format(strData, "mm/dd/yyyy")
         If DataConOra = True Then
            vOra = Format(strData, "hh:nn:ss")
         Else
            vOra = Format(OraDB, "hh:nn:ss")
         End If
         vOra = Replace(vOra, ".", ":")
         DataEora = vDat & " " & vOra
         'DataEora = Trim((Mid(StrData, 4, 2)) & "/" & Trim(Left(StrData, 2)) & "/" & Trim(Right(StrData, 2)))
      End If
   
      DataOraSQL = "#" & Trim(DataEora) & "#"

'SQL
'   Else
'      vDat = Format(strData, "yyyy/mm/dd")
'      vOra = OraDB
'
'      If DataConOra = True Then
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & "',102)"
'      Else
'         DataOraSQL = "CONVERT(DATETIME, '" & vDat & " " & vOra & "', 102)"
'      End If
'   End If
   
End Function


Public Sub MoveFormByDragDrop(MouseButton As Integer, objForm As Form)
   If MouseButton = vbLeftButton Then
       ReleaseCapture
       SendMessage objForm.hWnd, WM_NCLBUTTONDOWN, HTCAPTION, 0&
   End If
End Sub


Public Sub SetAlwaysOnTopMode(hWndOrForm As Variant, Optional ByVal OnTop As Boolean = True)
   Dim hWnd As Long
   ' get the hWnd of the form to be move on top
   If VarType(hWndOrForm) = vbLong Then
      hWnd = hWndOrForm
   Else
      hWnd = hWndOrForm.hWnd
   End If
   SetWindowPos hWnd, IIf(OnTop, HWND_TOPMOST, HWND_NOTOPMOST), 0, 0, 0, 0, _
   SWP_NOMOVE Or SWP_NOSIZE Or SWP_SHOWWINDOW
End Sub


'Funzione per leggere nel file INI
Public Function ReadINI(ByVal AppName As String, KeyName As String, Filename As String) As String
   Dim INIreturn As String
        
   INIreturn = String(255, Chr(0))
   ReadINI = Left(INIreturn, GetPrivateProfileString(AppName, KeyName, "", INIreturn, _
             Len(INIreturn), Filename))
End Function
'Funzione per scrivere nel file INI
Public Sub WriteINI(ByVal AppName As String, KeyName As String, NewString As String, Filename As String)
   Dim Flag As Integer
        
    Flag = WritePrivateProfileString(AppName, KeyName, NewString, Filename)
End Sub


Public Sub MsgInLogFile(Msg As String, pNomeFunzione As String, Optional pErrore As Boolean, Optional pDaSubMain As Boolean)   ', Optional pNomeLog As String, Optional pNuovoFile As Boolean)
   'se il parametro pNuovoFile  compilato significa che il file  diverso dallo standard

   Dim NumFile As Integer 'per aprire il file di esecuzioni(LOG)
   Dim vStrRec As String
   Dim vNomeFile As String
   
   On Error Resume Next
   
   
   vNomeFile = "LogUpdater_" & Year(Date) & "." & Format(Date, "mm") & ".cnf"
      
      
   Call VerificaEsistenzaPathCartella(App.Path & "\Log")
   
   
   If pErrore Then
      Msg = "ERRORE! -> " & Msg
   End If
   
   
   NumFile = FreeFile
      
   'Apro il file LOG
   Open App.Path & "\Log\" & vNomeFile For Append As #NumFile     'CREO IL FILE
      
      'Stampo il messaggio (la riga!)
      vStrRec = Format(Date, "yyyy/mm/dd") & "|" & _
                Format(Now, "hh:nn:ss") '& "|" & _
                pub_CodUtente
      
      vStrRec = vStrRec & "|" & Replace(Msg, Chr(13) + Chr(10), "")
      vStrRec = vStrRec & "|" & pNomeFunzione
      vStrRec = vStrRec & "|"
      
      Print #NumFile, vStrRec
      '+{榦ӱ=53?+jV+uY}4A65?AGT6A ???
      
      'STRUTTURA STRINGA : _
      DATA SISTEMA | ORA SISTEMA | CODICE UTENTE | STRINGA SQL | NOME FORM DI ESECUZIONE | CARATTERE DI FINE RIGA ()
      
   'Chiudo il file di LOG
   Close #NumFile
      
   'Questa istuzione mi serve per azzerare eventuali errori che possono verificarsi. In particolarte quando il comando _
    arriva da una form Modale l'istruzione MDIForm1.ActiveForm.Name genera l'errore 91
   On Error GoTo 0
         
End Sub


Public Function VerificaEsistenzaFile(pPathFile As String) As Boolean
   Dim MyFile As String
            
   'restituisce una stringa vuota se la cartella non esiste
   MyFile = Dir(pPathFile, vbNormal)
   If Len(Trim(MyFile)) = 0 Then
      'Il file non esiste
      VerificaEsistenzaFile = False
   Else
      'Il file esiste
      VerificaEsistenzaFile = True
   End If
End Function

Public Sub VerificaEsistenzaPathCartella(pPathCartella As String, Optional pSoloControllo As Boolean, Optional prEsistenza As Boolean)
   'Questa sub serve per controllare l'esistenza di una cartella e se non esiste la crea _
    salvo che il parametro pSoloControllo non sia TRUE. In questo caso effettua SOLO il controllo. _
    L'esito dell'esistenza  passato al parametro di ritorno prEsistenza (questo l'ho fatto perch _
    non ho voluto trasformare la Sub in Funzione perch gi usata all'interno del programma)
   
   Dim MyFolder As String
   
   'restituisce una stringa vuota se la cartella non esiste
   MyFolder = Dir(pPathCartella, vbDirectory)
   If Len(Trim(MyFolder)) = 0 Then
   'crea la cartella
      If pSoloControllo = False Then MkDir pPathCartella
      prEsistenza = False
   Else
      prEsistenza = True
   End If

End Sub


Public Sub KillaFile(pPathFile As String)
'QUESTA FUNZIONE PROVVEDE A CANCELLARE IL FILE PASSATO COME PARAMETRO "pPathFile"
   Dim vTentativi As Byte
 
   On Error GoTo GestErr
   
   vTentativi = 0
   
riprova:
   Kill pPathFile

   
GestErr:
   If err.Number = 53 Then
      Resume Next
   ElseIf err.Number <> 0 Then
      If vTentativi < 2 Then
         vTentativi = vTentativi + 1
         'Call PausaProgram(2)
         On Error GoTo 0
         GoTo riprova
      Else
         MsgBox err.Number & " - " & err.Description, vbCritical
      End If
   End If
   On Error GoTo 0
   
End Sub



Public Function GetNomeFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetNomeFile = Mid(PathFile, Pos + 1)
End Function

Public Function GetPathFile(PathFile As String) As String
'questa routine serve per recuperare da un path SOLO il Path della cartella escludendo il nome del file
   Dim Pos As Byte
   
   Pos = InStrRev(PathFile, "\")
   GetPathFile = Mid(PathFile, 1, Pos)
End Function

Public Function VerificaArrayInizializzato(v_Arr As Variant) As Boolean
   'Questa funzione mi restituisce TRUE se l'array  stato inizializzato
   On Local Error GoTo GestErr
   
   If (LBound(v_Arr) <= UBound(v_Arr)) Then VerificaArrayInizializzato = True

GestErr:
   
End Function

Public Function AddArrayElement(pArray As Variant, pElement As String) As String() ', Optional pSecondoElement As String) As String()
'Questa funzione richieder, per funzionare, di due argomenti: l'array su cui operare e l'elemento da aggiungere in coda.

  Dim NewArrSize As Integer
  
  ' Verifico se pArray  una array
   'If IsArray(pArray) Then
   If VerificaArrayInizializzato(pArray) = True Then

      ' Incremento di uno il numero di elementi
         NewArrSize = CInt(UBound(pArray) + 1)
         ReDim Preserve pArray(NewArrSize)
      ' Aggiungo in coda il nuovo elemento (se c' anche il secondo valore lo accodo alla stringa del primoElemento separandolo con "")
         pArray(NewArrSize) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
      
   Else
      ReDim pArray(0)
      pArray(0) = pElement '& " & IIf(Len(Trim(pSecondoElement)) > 0, pSecondoElement, "")"
   End If
   
   AddArrayElement = pArray
   
End Function

Public Function VerificaEsecuzioneEXE(PathExe As String) As Boolean
   Dim bf As Byte
   
   On Error GoTo err

   'Verifico SEMPRE che il file sista altrimenti NON pu essere in esecuzione !!!
   If VerificaEsistenzaFile(PathExe) = False Then
      VerificaEsecuzioneEXE = False
      Exit Function
   End If
   
   Open PathExe For Binary As 1
   Get #1, 1, bf
   Put #1, 1, bf
   Close #1

   On Error GoTo 0
   VerificaEsecuzioneEXE = False
   Exit Function
 
err:
   Close #1
   VerificaEsecuzioneEXE = True
   On Error GoTo 0
End Function


Public Sub PausaProgramma(pSecondi As Integer, _
                          Optional MenoDiUnSecondo As Boolean, Optional pUltraRapido As Boolean)
   Dim vTempoPart As Date
   Dim i As Long
   
   vTempoPart = DateAdd("s", pSecondi, Time)
   Do Until Time > vTempoPart
      DoEvents
      i = i + 1
      
      If pUltraRapido Then If i = 75000 Then Exit Do
      If MenoDiUnSecondo Then If i = 150000 Then Exit Do
   Loop
End Sub


Public Function FileNameFromPath(strFullPath As String) As String
     FileNameFromPath = Right(strFullPath, Len(strFullPath) - InStrRev(strFullPath, "\"))
End Function
 

Public Sub ShowFILE(pForm As Form, pPathFile As String)
   Dim llSuccess As Variant
   'Dim strPathFile As String

   If Len(Trim(pPathFile)) = 0 Then Exit Sub

   If Len(pPathFile) > 0 Then
      'ApriFax = ShortPathName(ApriFax)
      llSuccess = ShellExecute(pForm.hWnd, "Open", pPathFile, 0&, 0&, SW_SHOWNORMAL)
   End If
End Sub

